<?php

// تنظیم منطقه زمانی ایران/تهران
date_default_timezone_set('Asia/Tehran');

// بررسی زمان فعلی
$currentHour = (int) date('H');
$currentMinute = (int) date('i');

// اگر زمان بین 1 بامداد تا 8:30 صبح است، اسکریپت را متوقف کنید
if (($currentHour == 1 && $currentMinute >= 0) || ($currentHour > 1 && $currentHour < 8) || ($currentHour == 8 && $currentMinute < 30)) {
    die('ربات در این ساعت‌ها فعال نیست.');
}

// تابع تبدیل تاریخ میلادی به شمسی
function gregorian_to_jalali($gy, $gm, $gd, $mod = '') {
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    if ($gy > 1600) {
        $jy = 979;
        $gy -= 1600;
    } else {
        $jy = 0;
        $gy -= 621;
    }
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) - 80 + $gd + $g_d_m[$gm - 1];
    $jy += 33 * ((int)($days / 12053));
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    if ($days > 365) {
        $jy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    $jm = ($days < 186) ? 1 + (int)($days / 31) : 7 + (int)(($days - 186) / 30);
    $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
    return ($mod == '') ? array($jy, $jm, $jd) : $jy . $mod . $jm . $mod . $jd;
}

// تابع برای فرمت کردن قیمت با سه رقم اعشار و بولد کردن آن‌ها
function formatPrice($price) {
    // فرمت کردن قیمت با سه رقم اعشار
    $formattedPrice = number_format($price, 3, '.', ',');
    // بررسی اینکه آیا قیمت باید بولد شود (بر اساس داشتن سه رقم اعشار)
    if (preg_match('/\.\d{3}$/', $formattedPrice)) {
        return "<b>$formattedPrice</b>";
    }
    return $formattedPrice;
}

$updateTime = new DateTime();
$gregorianDate = $updateTime->format('Y-m-d H:i:s');

list($gy, $gm, $gd) = explode('-', $updateTime->format('Y-m-d'));
$gregorianTime = $updateTime->format('H:i:s');
list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);

$shamsiDate = $jy . '/' . $jm . '/' . $jd . ' ' . $gregorianTime;

// Token ربات تلگرام خود را وارد کنید
$telegramBotToken = '7424276677:AAFSsJ5c7b1FvRldeV9hf-ewCIrfgAULw2Q';
// شناسه کانال تلگرام خود را وارد کنید (می‌توانید از @username کانال استفاده کنید)
$telegramChannelId = '@moeinmollaee';
// ارزهایی که می‌خواهید قیمتشان را دنبال کنید
$cryptoCurrencies = [
    'BTC', 'ETH', 'BNB', 'SOL', 'TON', 'DOGE', 'ADA', 'TRX', '1000_SHIB', 'MATIC', 'ARB', 'FET', '1M_PEPE', 'NOT'
];

// قابلیت ارسال سایلنت
$silent = true; // می‌توانید این را به false تغییر دهید اگر می‌خواهید پیام‌ها سایلنت نباشند

// دریافت داده‌های قیمت از Nobitex
$nobitexUrl = "https://api.nobitex.ir/v2/orderbook/all";
$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => $nobitexUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
        "cache-control: no-cache"
    ),
));
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    die("Error: $err");
}

$nobitexData = json_decode($response, true);
$usdtPrice = isset($nobitexData['USDTIRT']['lastTradePrice']) ? $nobitexData['USDTIRT']['lastTradePrice'] / 10 : 'N/A'; // تصحیح قیمت تتر به تومان
// ساختن پیام برای ارسال به تلگرام
$message = "<b>💰 قیمت این لحظه‌ی ارزهای دیجیتال (به USDT):</b>\n\n";
foreach ($cryptoCurrencies as $crypto) {
    // اگر رمز ارز '1000_SHIB' باشد، در غیر این صورت از مقدار استاندارد استفاده کنید
    $cryptoSymbol = ($crypto === '1000_SHIB') ? 'SHIB' : $crypto;
    $price = isset($nobitexData[$cryptoSymbol.'USDT']['lastTradePrice']) ? $nobitexData[$cryptoSymbol.'USDT']['lastTradePrice'] : 'N/A';
    $formattedPrice = $price !== 'N/A' ? formatPrice($price) : 'N/A'; // تغییر به 3 رقم اعشار و بررسی بولد
    $message .= strtoupper($crypto) . ": $" . $formattedPrice . " USDT\n";
}

$message .= "\n💵 قیمت تتر به تومان: " . number_format($usdtPrice, 0, '.', ',') . " تومان";

// اضافه کردن زمان بروز رسانی به پیام
$message .= "\n\n<b>⏰ تاریخ بروز رسانی: $shamsiDate</b>";

// افزودن آی دی کانال به پیام
$channelIdIcon = "❇️ : $telegramChannelId";
$message .= "\n\n$channelIdIcon";

// URL درخواست API برای تلگرام
$telegramApiUrl = "https://api.telegram.org/bot$telegramBotToken/sendMessage";

// داده‌های POST برای ارسال پیام به تلگرام
$postData = [
    'chat_id' => $telegramChannelId,
    'text' => $message,
    'parse_mode' => 'HTML', // برای استفاده از HTML در پیام
    'disable_notification' => $silent
];

// ارسال درخواست POST به تلگرام با استفاده از CURL
$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => $telegramApiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query($postData),
    CURLOPT_HTTPHEADER => array(
        "Content-Type: application/x-www-form-urlencoded"
    ),
));

$response = curl_exec($curl);
$err = curl_error($curl);

if ($err) {
    die("Error: $err");
}

curl_close($curl);

echo "پیام با موفقیت ارسال شد";

?>
